<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Variable to hold unit string -->
    <xsl:variable name="unit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'"> st</xsl:when>
            <xsl:otherwise> m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Horizontal Alignment Legal Description -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html lang="en">
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title>Výpis Směrové řešení Uzavřené</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2>Výpis Směrové řešení Uzavřené</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <div style="margin-left:0.5in;margin-right:0.5in">
                                    <xsl:for-each select="HorizontalAlignment">
                                        <table cellpadding="2" cellspacing="1">
                                            <tbody>
                                                <tr>
                                                    <th align="right"><br/>Trasa Název:</th>
                                                    <td align="left"><br/><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" valign="top">Trasa Popis:</th>
                                                    <td align="left" valign="top"><xsl:value-of select="@description"/><br/>&#xa0;</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <xsl:apply-templates select="HorizontalElements/HorizontalLine | HorizontalElements/HorizontalCircle | HorizontalElements/HorizontalSpiral"/>
                                        <xsl:if test="@area > 0">
                                            a POČÁTEČNÍ BOD; Obsahuje méně nebo více
                                            <xsl:if test="//@linearUnits = 'Imperial'">
                                                <xsl:value-of select="cif:acreFormat(number(@area) div 43560)"/> akrů,
                                            </xsl:if>
                                            <xsl:if test="//@linearUnits = 'Metric'">
                                                <xsl:value-of select="cif:acreFormat(number(@area) div 10000)"/> hektarů.
                                            </xsl:if>
                                        </xsl:if>
                                        <br/>
                                    </xsl:for-each>
                                </div>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Horizontal Line -->
    <xsl:template match="HorizontalLine">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Začíná v
                <xsl:choose>
                    <xsl:when test="Start/@name">
                        <xsl:value-of select="Start/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise>
                        bodě,<br/>
                    </xsl:otherwise>
                </xsl:choose>
                 tento bod je POČÁTEČNÍ BOD;<br/>
                odtud
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>,
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>,<br/>
            </xsl:when>
            <xsl:when test="position() = last()">
                odtud
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>,
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>.<br/>
            </xsl:when>
            <xsl:otherwise>
                odtud
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>,
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>,<br/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Circle -->
    <xsl:template match="HorizontalCircle">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Začíná v
                <xsl:choose>
                    <xsl:when test="Start/@name">
                        <xsl:value-of select="Start/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise>
                        a point,<br/>
                    </xsl:otherwise>
                </xsl:choose>
                přičemž tento bod je POČÁTEČNÍ BOD;<br/>
                k bodu na oblouku, 
                <xsl:choose>
                    <xsl:when test="End/@name">
                        <xsl:value-of select="End/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise><br/></xsl:otherwise>
                </xsl:choose>
                který má poloměr 
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                <xsl:value-of select="$unit"/>
                a středový úhel 
                <xsl:value-of select="cif:angularFormat(number(@delta))"/>,<br/>
                odtud podél oblouku o délce 
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>&#xa0;
                <xsl:value-of select="$unit"/>,<br/>
                s tětivou ve směru 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
                a délce  
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                <xsl:value-of select="$unit"/>,
                <br/>
            </xsl:when>
            <xsl:when test="position() = last()">
                k bodu na oblouku, 
                <xsl:choose>
                    <xsl:when test="End/@name">
                        <xsl:value-of select="End/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise><br/></xsl:otherwise>
                </xsl:choose>
                který má poloměr 
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                <xsl:value-of select="$unit"/>
                a středový úhel 
                <xsl:value-of select="cif:angularFormat(number(@delta))"/>,<br/>
                odtud podél oblouku o délce 
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>,<br/>
                s tětivou ve směru 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
                a délce 
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                <xsl:value-of select="$unit"/>.<br/>
            </xsl:when>
            <xsl:otherwise>
                k bodu na oblouku, 
                <xsl:choose>
                    <xsl:when test="End/@name">
                        <xsl:value-of select="End/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise><br/></xsl:otherwise>
                </xsl:choose>
                který má poloměr 
                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                <xsl:value-of select="$unit"/>
                a středový úhel 
                <xsl:value-of select="cif:angularFormat(number(@delta))"/>,<br/>
                odtud podél oblouku o délce 
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                <xsl:value-of select="$unit"/>,<br/>
                s tětivou ve směru 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
                a délce 
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                <xsl:value-of select="$unit"/>.<br/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Spiral -->
    <xsl:template match="HorizontalSpiral">
        <xsl:choose>
            <xsl:when test="position() = 1">
                Začíná v
                <xsl:choose>
                    <xsl:when test="Start/@name">
                        <xsl:value-of select="Start/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise>
                        bodě,<br/>
                    </xsl:otherwise>
                </xsl:choose>
                přičemž tento bod je POČÁTEČNÍ BOD;<br/>
                k bodě na přechodnici, 
                <xsl:choose>
                    <xsl:when test="End/@name">
                        <xsl:value-of select="End/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise><br/></xsl:otherwise>
                </xsl:choose>
                jejíž tětiva je ve směru 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
                a délce 
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                <xsl:value-of select="$unit"/>,<br/>
            </xsl:when>
            <xsl:when test="position() = last()">
                k bodu na přechodnici, 
                <xsl:choose>
                    <xsl:when test="End/@name">
                        <xsl:value-of select="End/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise><br/></xsl:otherwise>
                </xsl:choose>
                jejíž tětiva je ve směru 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
                a délce 
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                <xsl:value-of select="$unit"/>.<br/>
            </xsl:when>
            <xsl:otherwise>
                k bodu na přechodnici, 
                <xsl:choose>
                    <xsl:when test="End/@name">
                        <xsl:value-of select="End/@name"/>,<br/>
                    </xsl:when>
                    <xsl:otherwise><br/></xsl:otherwise>
                </xsl:choose>
                jejíž tětiva je ve směru 
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>,
                a délce 
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
                <xsl:value-of select="$unit"/>,<br/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jedno uzavřené směrové řešení v <em>Zahrnout</em> v
                <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em> nebo <em>Nástroje &gt; XML 
                Výpisy &gt; Geometrie</em>.
            </p>
            <p class="normal1" lang="en">
                Tebto výpis není vhodný pro referenční trasu.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
